import React, { FC, CSSProperties } from 'react';
import cx from 'classnames';
import { TextProps } from './Text.types';
import css from './Text.module.css';

export const Text: FC<TextProps> = (props) => {
  const {
    children,
    overflow = 'visible',
    color,
    icon,
    align = 'start',
    style: outerStyle = {},
    ...restProps
  } = props;

  const className = cx(css.Text, props.className, {
    [css.Text_overflow_hidden]: overflow === 'hidden',
    [css.Text_align_start]: align === 'start',
    [css.Text_align_end]: align === 'end',
    [css.Text_align_center]: align === 'center',
  });
  const style: CSSProperties = {
    ...outerStyle,
    color,
  };

  return (
    <div {...restProps} className={className} style={style}>
      <div className={css.Text__textWrap}>{children}</div>
      {icon && icon(css.Text__icon)}
    </div>
  );
};
