import React from 'react';
import { connect } from 'react-redux';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import Menu from '@crm/components/dist/lego2/Menu';
import Modal from '@crm/components/dist/lego2/Modal';
import Select from 'components/Select';

import Toolbar from 'components/Toolbar';

import actions from 'actions';
import { unv } from 'utils/common';
import css from './styles.scss';

const param = {
  formHeader: 'Переместить',
};

/*
 * Есть баг при submit формы по Enter
 * */

class SelectQueueDialog extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      filter: '',
    };
  }

  componentDidMount() {
    if (this.props.initOnMount && this.props.onMount) {
      this.props.onMount();
    }
  }

  componentWillUnmount() {
    if (this.props.destroyOnUnmount) {
      this.props.destroy();
    }
  }

  handleChangeSearch = (val) => {
    this.setState({ filter: val });
  };

  resetFilter = () => {
    this.setState({ filter: '' });
  };

  onMenuChange = (event) => {
    this.props.onQueueClick(event.target.value);
  };

  render() {
    const {
      selectQueueDialogVisible,
      selectedQueueId,
      currentQueueId,
      queueList,
      ticketId,
      onDialogRequestClose,
      onQueueSelectClick,
      formType,
      formHeader,
    } = this.props;

    const handlerOk = () => {
      onQueueSelectClick(ticketId, selectedQueueId, formType, this.itemsMap[selectedQueueId]);
    };

    const handlerExit = () => {
      onDialogRequestClose();
    };

    const handleSubmit = (e) => {
      if (e.keyCode === 13 && selectedQueueId !== undefined) {
        handlerOk();
      }
    };

    const filter = this.state.filter && this.state.filter.toLowerCase();
    this.itemsMap = {};

    return (
      <Modal
        size="fixHeight"
        visible={Boolean(selectQueueDialogVisible)}
        onClose={handlerExit}
        onExited={this.resetFilter}
      >
        <div role="presentation" className={css.dialog} onKeyUp={handleSubmit}>
          <h2 className="dialog__header">{formHeader}</h2>
          <Textinput
            size="m"
            value={this.state.filter}
            onChange={this.handleChangeSearch}
            autoFocus
          />
          <Menu
            size="m"
            className={css.body}
            value={selectedQueueId}
            onChange={this.onMenuChange}
            items={queueList
              .filter((item) => {
                this.itemsMap[item.id] = item;

                if (currentQueueId === item.id) {
                  return false;
                }

                let index;
                if (filter) {
                  index = item.name.toLowerCase().indexOf(filter);
                }

                if (filter && index === -1) {
                  return false;
                }

                return true;
              })
              .map((item) => {
                const index = item.name.toLowerCase().indexOf(filter);
                const content = filter ? (
                  <Select value={item.name} range={[index, index + filter.length]} />
                ) : (
                  item.name
                );

                return {
                  value: item.id,
                  content,
                };
              })}
          />
          <div className={css.footer}>
            <Toolbar>
              <Button
                size="m"
                view="action"
                disabled={selectedQueueId === undefined}
                onClick={handlerOk}
              >
                Сохранить
              </Button>
              <Button size="m" view="pseudo" onClick={handlerExit}>
                Отмена
              </Button>
            </Toolbar>
          </div>
        </div>
      </Modal>
    );
  }
}

const mapState = (state, props) => ({
  selectQueueDialogVisible: state.ui.selectQueueDialogVisible || props.show || false,
  selectedQueueId: state.ui.selectedQueueId,
  currentQueueId: unv(props.selectedId, state.ui.currentQueueId),
  queueList: state.queueList,
  ticketId: state.ui.currentTicketId,
  formType: state.ui.formType,
  rootId: state.ui.rootId,
  formHeader: param.formHeader,
});

const mapDispatch = (dispatch, props) => ({
  onDialogRequestClose: () => {
    dispatch(actions.uiToggleSelectQueueDialog(false));
    dispatch(actions.uiSelectQueue(undefined));
    dispatch(actions.uiCurrentQueue(undefined));

    if (props.toggle) {
      props.toggle(false);
    }
  },

  onMount: () => {
    dispatch(actions.viewSupportQueueList());
  },

  onQueueClick: (queueId) => dispatch(actions.uiSelectQueue(queueId)),

  destroy: () => {
    dispatch(actions.uiToggleSelectQueueDialog(false));
    dispatch(actions.uiSelectQueue(undefined));
    dispatch(actions.uiCurrentQueue(undefined));
  },

  onQueueSelectClick: () => (id, queueId, formType, queueItem) => {
    if (props.onChange) {
      props.onChange(queueId, queueItem);
    }

    if (props.toggle) {
      props.toggle(false);
    }
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  ...{
    onQueueSelectClick: dispatchProps.onQueueSelectClick(stateProps.rootId),
  },
});

export default connect(mapState, mapDispatch, mergeProps)(SelectQueueDialog);
