import React from 'react';
import Modal from '@crm/components/dist/lego2/Modal';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import TreeView from 'components/TreeView_old';
import filterTree from 'utils/filter-tree';
import Toolbar from 'components/Toolbar';

import css from './styles.scss';

class SelectTreeDialog extends React.Component {
  state = {
    item: undefined,
  };

  componentDidMount() {
    if (this.props.initOnMount && this.props.onMount) {
      this.props.onMount();
    }
  }

  onItemClick = (item) => {
    this.setState({
      item,
      currentSelect: item.id,
    });
  };

  onExit = () => {
    this.state.currentSelect = undefined;

    if (this.props.onExit) {
      this.props.onExit();
    }

    if (this.props.onDialogRequestClose) {
      this.props.onDialogRequestClose(this.state.currentSelect);
    }
  };

  componentWillUnmount() {
    if (this.props.destroyOnUnmount) {
      this.props.destroy();
    }
  }

  onOK = () => {
    const { ticketId } = this.props;
    const { item } = this.state;

    if (this.props.onOK) {
      this.props.onOK(this.state.item);
      return;
    }

    this.props.onItemClick(item.id);
    this.props.onOKClick(ticketId, item.id, this.props.formType, item);
  };

  handleSubmit = (e) => {
    if (e.keyCode === 13 && this._isValid()) {
      this.onOK();
    }
  };

  clearSelected = () => {
    this.setState({
      currentSelect: undefined,
    });
  };

  _isValid = () =>
    this.state.currentSelect && this.state.currentSelect !== this.props.selectedItemId;

  render() {
    const {
      isVisible,
      data,
      onChangeFilterText,
      searchFilterText,
      canSelectAll,
      formHeader,
    } = this.props;

    return (
      <Modal
        visible={isVisible}
        onClose={this.onExit}
        onExited={this.clearSelected}
        size="fixHeight"
      >
        <div tabIndex="-1" className={css.dialog} onKeyUp={this.handleSubmit}>
          <div className={css.header}>
            <h2 className="dialog__header">{formHeader}</h2>
            <Textinput value={searchFilterText} onChange={onChangeFilterText} autoFocus size="m" />
          </div>
          <div className={css.body}>
            <TreeView
              data={filterTree(data.items, searchFilterText)}
              onItemClick={this.onItemClick}
              selectedId={this.state.currentSelect}
              currentId={this.props.selectedItemId}
              level={0}
              canSelectAll={canSelectAll}
              isForceOpen={searchFilterText !== ''}
            />
          </div>
          <div className={css.footer}>
            <Toolbar>
              <Button size="m" view="action" disabled={!this._isValid()} onClick={this.onOK}>
                Сохранить
              </Button>
              <Button size="m" view="pseudo" onClick={this.onExit}>
                Отмена
              </Button>
            </Toolbar>
          </div>
        </div>
      </Modal>
    );
  }
}

export default SelectTreeDialog;
