import React, { ComponentType, Suspense } from 'react';
import { LoadFn, LazyWithSuspenseParams } from './lazyWithSuspense.types';

export const lazyWithSuspense = <T extends ComponentType>(
  loadFn: LoadFn<T>,
  params: LazyWithSuspenseParams = {},
) => {
  const { fallback: paramsFallback = <span /> } = params;
  const Component = React.lazy(loadFn);

  const Wrapper = (props) => {
    const { fallback = paramsFallback, ...restProps } = props;

    return (
      <Suspense fallback={fallback}>
        <Component {...restProps} />
      </Suspense>
    );
  };

  return Wrapper as T | React.FC<LazyWithSuspenseParams>;
};
