export default {
  behaviors: {},
  injectBehaviors(behaviors) {
    this.behaviors = { ...this.behaviors, ...behaviors };
  },
  reducer(state, action) {
    const {
      items,
    } = state;

    if (
      action &&
      typeof action.type === 'string' &&
      Array.isArray(items)
    ) {
      const behavior = this.behaviors[action.type];
      const meta = action.meta || {};

      const {
        id,
        idSlug = 'id',
      } = meta;

      if (id && behavior) {
        let isChange = false;
        const updateItems = items.map((item) => {
          if (item[idSlug] === id) {
            isChange = true;

            return behavior(item, action);
          }

          return item;
        });

        if (isChange) {
          return {
            ...state,
            items: updateItems,
          };
        }
      }
    }

    return state;
  },
};
