import * as types from './actionTypes';

export const setExtraFetchParam = (name, key, value) => ({
  type: types.SET_EXTRA_FETCH_PARAM,
  payload: { key, value },
  meta: { name },
});

export const clearLoad = name => ({ type: types.CLEAR_LOAD, meta: { name } });
export const load = (name, reset = false) => ({ type: types.LOAD, reset, meta: { name } });
export const update = (name, updater, isRaw = false) => ({
  type: types.UPDATE,
  updater,
  isRaw,
  meta: { name },
});
export const reset = name => ({ type: types.RESET, meta: { name } });
export const resetState = name => ({ type: types.RESET_STATE, meta: { name } });

export const setResetData = name => ({ type: types.SET_RESET_DATA, meta: { name } });
export const clearResetData = name => ({ type: types.CLEAR_RESET_DATA, meta: { name } });
export const resetData = name => ({ type: types.RESET_DATA, meta: { name } });
export const refreshData = (name, data) => ({ type: types.REFRESH_DATA, data, meta: { name } });

export const request = (name, data) => ({ type: types.REQUEST, data, meta: { name } });
export const receive = (name, data) => ({ type: types.RECEIVE, data, meta: { name } });
export const failed = (name, error, isError = false) => ({
  type: types.FAILED,
  error,
  isError,
  meta: { name },
});

export const destroy = name => ({ type: types.DESTROY, meta: { name } });
export const initialize = (name, settings) => ({
  type: types.INITIALIZE,
  payload: settings,
  meta: { name },
});

export const sortChange = (name, fieldName, sortDirection) => ({
  type: types.SORT_CHANGE,
  fieldName,
  sortDirection,
  meta: { name },
});

export const triggerSortChange = (name, fieldName) => ({
  type: types.TRIGGER_SORT_CHANGE,
  fieldName,
  meta: { name },
});

export const refresh = name => ({ type: types.REFRESH, meta: { name } });
export const reload = name => ({ type: types.RELOAD, meta: { name } });

export const changeColumns = (name, columnsMap) => ({
  type: types.CHANGE_COLUMNS,
  payload: columnsMap,
  meta: { name },
});

export const setUpdateInterval = (name, delay) => ({
  type: types.SET_UPDATE_INTERVAL,
  payload: delay,
  meta: { name },
});

export const startUpdate = name => ({ type: types.START_UPDATE, meta: { name } });
export const stopUpdate = name => ({ type: types.STOP_UPDATE, meta: { name } });

export const itemUpdate = (name, itemAction) => ({
  type: types.ITEM_UPDATE,
  itemAction,
  meta: { name },
});
