import React from 'react';
import PropTypes from 'prop-types';
import InfiniteList, { WithNavigationInfiniteList } from 'components/InfiniteList';

const ListView = props => {
  const {
    component: Component,
    selectedId,
    itemProps,
    itemKey,
    children,
    withNavigation,
    items,
    ...other
  } = props;

  delete other.onSortChange;
  delete other.isLoad;
  delete other.changeColumns;
  delete other.columnVisibility;

  const renderChildren = () => {
    if (children) {
      if (typeof children === 'function') {
        return children(props);
      }
      return children;
    }

    if (Component) {
      if (Array.isArray(items) && items.length) {
        return items.map((item, index) => {
          let id;
          if (typeof itemKey === 'function') {
            id = itemKey(item);
          } else if (typeof itemKey === 'string') {
            id = item[itemKey];
          }

          id = id || index;

          return <Component key={id} id={id} data={item} {...itemProps} />;
        });
      }
    }

    return null;
  };

  const InfiniteComponent = withNavigation ? WithNavigationInfiniteList : InfiniteList;

  return (
    <InfiniteComponent {...other} selected={selectedId}>
      {renderChildren()}
    </InfiniteComponent>
  );
};

ListView.propTypes = {
  component: PropTypes.func,
  withNavigation: PropTypes.bool,
  children: PropTypes.oneOfType([PropTypes.node, PropTypes.func]),
  items: PropTypes.arrayOf(PropTypes.object),
  selectedId: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
  itemProps: PropTypes.objectOf(PropTypes.any),
  itemKey: PropTypes.oneOfType([PropTypes.string, PropTypes.func]),
};

ListView.defaultProps = {
  component: undefined,
  withNavigation: true,
  children: undefined,
  items: undefined,
  selectedId: undefined,
  itemProps: {},
  itemKey: 'id',
};

export default ListView;
