import cx from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
import defaultTheme from './style.modules.scss';

const propTypes = {
  name: PropTypes.string.isRequired,
  title: PropTypes.string.isRequired,
  sortable: PropTypes.bool,
  onClick: PropTypes.func,
  style: PropTypes.objectOf(PropTypes.any),
  sortType: PropTypes.string,
  theme: PropTypes.objectOf(PropTypes.string),
};

const defaultProps = {
  sortable: false,
  onClick: undefined,
  style: undefined,
  sortType: 'none',
  theme: defaultTheme,
};

const SORT_SIGN = {
  none: <span className={defaultTheme.sortArrow_default}><i className="material-icons">arrow_drop_down</i></span>,
  asc: <span className={defaultTheme.sortArrow_active}><i className="material-icons">arrow_drop_up</i></span>,
  desc: <span className={defaultTheme.sortArrow_active}><i className="material-icons">arrow_drop_down</i></span>,
};

export default class HeaderCell extends React.Component {
  render() {
    const {
      name,
      title,
      sortable,
      style,
      onClick,
      sortType,
      theme,
    } = this.props;

    if (sortable) {
      return (
        <a
          tabIndex="0"
          key={name}
          className={theme.cell_header}
          style={style}
          onClick={() => onClick(name)}
        >
          <span>
            <span>{title}</span>
            {sortable && SORT_SIGN[sortType]}
          </span>
        </a>
      );
    }

    return (
      <div
        key={name}
        className={theme.cell_header}
        style={style}
      >
        <span>{title}</span>
      </div>
    );
  }
}

HeaderCell.propTypes = propTypes;
HeaderCell.defaultProps = defaultProps;
