/*
eslint-disable
react/prefer-stateless-function,
jsx-a11y/anchor-is-valid,
jsx-a11y/no-noninteractive-tabindex,
jsx-a11y/click-events-have-key-events,
jsx-a11y/no-static-element-interactions,
*/
import React from 'react';
import PropTypes from 'prop-types';
import css from './style.modules.scss';

class Row extends React.Component {
  static propTypes = {
    item: PropTypes.objectOf(PropTypes.any).isRequired,
    columns: PropTypes.objectOf(PropTypes.any).isRequired,
    columnsStyle: PropTypes.objectOf(PropTypes.any),
    index: PropTypes.number.isRequired,
    cellClassName: PropTypes.string,
    selected: PropTypes.bool,
    canSelect: PropTypes.bool,
    onClick: PropTypes.func,
    onDoubleClick: PropTypes.func,
  };

  static defaultProps = {
    cellClassName: undefined,
    columnsStyle: undefined,
    onClick: undefined,
    onDoubleClick: undefined,
    selected: false,
    canSelect: false,
  };

  render() {
    const {
      item,
      index,
      columns,
      cellClassName,
      columnsStyle,
      selected,
      canSelect,
      onClick,
      onDoubleClick,
    } = this.props;

    return (
      <a
        tabIndex="0"
        className={
          (selected && css.row_selected) || (canSelect && css.row_canSelect) || css.row_default
        }
        onClick={onClick}
        onDoubleClick={onDoubleClick}
      >
        <div className={cellClassName} style={columnsStyle && columnsStyle.index}>
          {index}
        </div>
        {columns.map(column => {
          const value = item[column.name];
          let result;

          if (value === true) {
            result = <i className="fa fa-check" aria-hidden />;
          } else if (value || value === 0) {
            result = <span>{value}</span>;
          } else {
            result = <span>&nbsp;</span>;
          }

          return (
            <div
              key={column.name}
              className={cellClassName}
              style={columnsStyle && columnsStyle[column.name]}
            >
              {result}
            </div>
          );
        })}
      </a>
    );
  }
}

export default Row;
