import React from 'react';
import PropTypes from 'prop-types';
import { AdaptiveIntervalByTabVisibility } from 'services/AdaptiveInterval';

const interval = (WrapComponent) => {
  class Interval extends React.Component {
    componentDidMount() {
      this.updateInterval();
    }

    componentWillReceiveProps(nextProps) {
      if (nextProps.delay !== this.props.delay) {
        this.updateInterval(nextProps);
      }
    }

    componentWillUnmount() {
      this.clearInterval();
    }

    clearInterval() {
      if (this.interval) {
        this.interval.destroy();
        this.interval = undefined;
      }
    }

    updateInterval(nextProps) {
      if (nextProps) {
        this.clearInterval();

        if (nextProps.delay) {
          this.interval = new AdaptiveIntervalByTabVisibility(this.props.callback, nextProps.delay);
        }
      } else if (this.props.delay) {
        this.interval = new AdaptiveIntervalByTabVisibility(this.props.callback, this.props.delay);
      }
    }

    render() {
      const passProps = { ...this.props };

      delete passProps.delay;
      delete passProps.callback;

      return <WrapComponent {...passProps} />;
    }
  }

  Interval.propTypes = {
    delay: PropTypes.number,
    callback: PropTypes.func,
  };

  Interval.defaultProps = {
    delay: undefined,
    callback: () => {},
  };

  return Interval;
};

export default interval;
