import get from 'lodash/get';

export const getState = (state, name) => get(state, `infiniteList.${name}`);

export const getItem = (state, name, id, idSlug = 'id') => {
  const instanceState = getState(state, name);
  if (instanceState && Array.isArray(instanceState.items)) {
    return instanceState.items.find(item => item[idSlug] === id);
  }

  return null;
};

export const getIsFetch = (state, name) => get(state, `infiniteList.${name}.isFetch`);

export const isLoad = (state, name) => get(state, `infiniteList.${name}.isLoad`);
