import { connect } from 'react-redux';
import get from 'lodash/get';
import store from 'store';
import React from 'react';
import Modal from '@crm/components/dist/lego2/Modal';
import { destroy, toggle } from './actions';
import { NAME } from './constants';
import reducers from './reducers';

store.injectReducer(NAME, reducers);

export const connectorModal = (WrapComponent) => {
  const mapState = (state, props) => ({
    ...get(state, `${NAME}.${props.name}`),
  });

  @connect(mapState)
  class ReduxModal extends React.Component {
    componentWillUnmount() {
      if (this.props.show) {
        this.props.dispatch(destroy(this.props.name));
      }
    }

    close = () => {
      this.props.dispatch(destroy(this.props.name));
    };

    open = () => {
      this.props.dispatch(toggle(this.props.name, true));
    };

    render() {
      return (
        <WrapComponent size="mid" {...this.props} visible={this.props.show} onClose={this.close} />
      );
    }
  }
  ReduxModal.WrapComponent = WrapComponent;

  return ReduxModal;
};

export default connectorModal(Modal);
