import { connect } from 'react-redux';
import { Component, createElement } from 'react';
import PropTypes from 'prop-types';
import get from 'lodash/get';
import { destroy, toggle } from './actions';
import { NAME } from './constants';
import reducers from './reducers';

window.reduxStore.injectReducer(NAME, reducers);

export default (WrapComponent) => {
  const mapState = (state, props) => ({
    visible: Boolean(get(state, `${NAME}.${props.name}.show`)),
  });

  class ReduxModal extends Component {
    static propTypes = {
      name: PropTypes.string.isRequired,
      dispatch: PropTypes.func.isRequired,
      autoOpen: PropTypes.bool,
    };

    static defaultProps = {
      autoOpen: false,
    };

    componentDidMount() {
      if (this.props.autoOpen) {
        this.open();
      }
    }

    componentWillUnmount() {
      if (this.props.visible) {
        this.props.dispatch(destroy(this.props.name));
      }
    }

    close = () => {
      this.props.dispatch(destroy(this.props.name));
      if (this.props.onClose) {
        this.props.onClose();
      }
    };

    open = () => {
      this.props.dispatch(toggle(this.props.name, true));
    };

    render() {
      const props = {
        ...this.props,
        onClose: this.close,
      };

      delete props.autoOpen;

      return createElement(WrapComponent, props);
    }
  }
  ReduxModal.WrapComponent = WrapComponent;

  return connect(mapState)(ReduxModal);
};
