import React from 'react';
import PropTypes from 'prop-types';
import TreeView from 'uiLib/TreeView';
import cx from 'classnames';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import Icon2 from '@crm/components/dist/lego2/Icon';
import Icon from 'lego/components/Icon';
import Toolbar from 'components/Toolbar';
import { filterMap } from 'utils/filter-tree';
import css from './styles.modules.scss';

export default class FilterTreeView extends React.Component {
  constructor(props) {
    super(props);
    this.state = { searchText: '' };
  }

  onChangeFilterText = (text) => {
    this.setText(text);
    const { onTextChange } = this.props;
    if (onTextChange) {
      onTextChange(text);
    }
  };

  getText = () => this.state.searchText;

  setText = (text) => {
    if (text === this.state.text) {
      return;
    }

    this.setState({ searchText: text });
  };

  render() {
    const {
      clearButton,
      toggleButtons,
      classNameTree,
      autoFocus,
      predicate,
      fixHeight,

      toggleCollapse,
      onArrowClick,
    } = this.props;

    let options;
    if (predicate) {
      options = { predicate };
    }

    return (
      <div className={cx(css.root, this.props.className)}>
        {this.props.showToolbar && (
          <Toolbar className={css.header}>
            <Textinput
              placeholder="Поиск"
              value={this.state.searchText}
              onChange={this.onChangeFilterText}
              hasClear={false}
              autoFocus={autoFocus}
              iconRight={<Icon2 svg="loupe" />}
            />
            {toggleButtons && (
              <span className={css.toggleCollapseButton}>
                <Button
                  view="pseudo"
                  onClick={this.props.collapseOpen}
                  title="Развернуть"
                  pin="round-brick"
                  icon={(iconCls) => <Icon className={iconCls} pack="fontawesome" icon="expand" />}
                />
                <Button
                  view="pseudo"
                  onClick={this.props.collapseClose}
                  title="Свернуть"
                  pin="clear-round"
                  icon={(iconCls) => (
                    <Icon className={iconCls} pack="fontawesome" icon="compress" />
                  )}
                />
              </span>
            )}
            {clearButton && (
              <Button
                view="pseudo"
                onClick={this.props.clearSelect}
                title="Очистить"
                icon={(iconCls) => <Icon2 className={iconCls} type="cross" />}
              />
            )}
          </Toolbar>
        )}
        <TreeView
          className={cx(classNameTree, { [css.treeRoot_fixHeight]: fixHeight })}
          labelClassName={this.props.labelClassName}
          selectedMap={this.props.selectedMap}
          collapseMap={this.props.collapseMap}
          forceExpanded={Boolean(this.state.searchText)}
          list={filterMap(this.props.list, this.state.searchText, options)}
          theme={this.props.treeNodeTheme}
          clickMode={this.props.clickMode}
          onItemClick={this.props.onItemClick}
          onArrowClick={(id) => {
            if (toggleCollapse) {
              toggleCollapse(id);
            }

            if (onArrowClick) {
              onArrowClick(id);
            }
          }}
          componentNode={this.props.componentNode}
          canItemClick={this.props.canItemClick}
        />
      </div>
    );
  }
}

FilterTreeView.propTypes = {
  onTextChange: PropTypes.func,
  showToolbar: PropTypes.bool,
  clearButton: PropTypes.bool,
  toggleButtons: PropTypes.bool,
  autoFocus: PropTypes.bool,
  fixHeight: PropTypes.bool,
  classNameTree: PropTypes.string,
  ...TreeView.propTypes,
};

FilterTreeView.defaultProps = {
  onTextChange: undefined,
  showToolbar: true,
  clearButton: false,
  toggleButtons: false,
  autoFocus: false,
  fixHeight: false,
  classNameTree: css.treeRoot,
};
