import mapValues from 'lodash/mapValues';

export default values =>
  mapValues(values, value => {
    // eslint-disable-next-line no-underscore-dangle
    if (typeof value === 'object' && value._DATA_TYPE === 'TREE_SELECT') {
      if (Array.isArray(value.selectedArrayOptimized) && value.selectedArrayOptimized.length) {
        return value.selectedArrayOptimized;
      }

      return undefined;
    }

    if (typeof value === 'string' && !value) {
      return undefined;
    }

    return value;
  });
