import get from 'lodash/get';
import { NAME } from './constants';

const DEFAULT_KEYS = ['selectedMap', 'selectedArray', 'selectedArrayOptimized'];

export default (name, _keys) => (state) => {
  let keys = DEFAULT_KEYS;
  if (Array.isArray(_keys)) {
    keys = _keys;
  }

  // path to redux instance
  const path = `${NAME}.${name}`;

  const itemState = get(state, path) || {};
  const storeData = {};
  keys.forEach((key) => { storeData[key] = itemState[key]; });

  return {
    path,
    state: storeData,
  };
};
