import get from 'lodash/get';
import { NAME } from './constants';

export const getState = (state, name) => get(state, [NAME, name]);

export const getNestedValue = (name) => (state) => {
  const instanceState = get(state, [NAME, name], {});

  let selectedItem;
  if (Array.isArray(instanceState.selectedArray) && instanceState.selectedArray.length === 1) {
    selectedItem = instanceState.list[instanceState.selectedArray[0]];
  }

  return {
    selectedItem,
    selectedMap: instanceState.selectedMap,
    selectedArray: instanceState.selectedArray,
    selectedArrayOptimized: instanceState.selectedArrayOptimized,
    _DATA_TYPE: 'TREE_SELECT',
  };
};
