import React, { Component } from 'react';
import debounce from 'lodash/debounce';
import css from './styles.scss';

export default class Body extends Component {
  constructor(props) {
    super(props);
    this.bodyRef = React.createRef();
    this.state = {
      container: null,
    };
  }

  handleWindowResize = debounce(() => {
    const { container } = this.state;
    if (container.height !== this.bodyRef.current.offsetHeight) {
      this.setState({ container: this.getContainer() });
    }
    if (container.width !== this.bodyRef.current.offsetWidth) {
      this.setState({ container: this.getContainer() });
    }
  }, 300);

  getContainer = () => {
    return {
      height: this.bodyRef.current.offsetHeight,
      width: this.bodyRef.current.offsetWidth,
    };
  };

  componentDidMount() {
    window.addEventListener('resize', this.handleWindowResize);
    this.setState({ container: this.getContainer() });
  }

  componentWillUnmount() {
    window.removeEventListener('resize', this.handleWindowResize);
    this.handleWindowResize.cancel();
  }

  render() {
    const { container } = this.state;
    if (this.state.container === null) {
      return <div ref={this.bodyRef} className={css.body} />;
    }
    const child = React.Children.only(this.props.children);
    return (
      <div ref={this.bodyRef} className={css.body}>
        {React.cloneElement(child, { ...child.props, container })}
      </div>
    );
  }
}
