import api from 'api';
import * as t from './actionTypes';

export const toggle = () => (dispatch) => dispatch({ type: t.TOGGLE });

export const open = (callback) => (dispatch) => {
  dispatch({ type: t.OPEN, callback });
};

export const loadData = (ticketId, workspace = null, queueId, eId, eType) => (dispatch) =>
  api.view.support.category
    .list(ticketId, workspace, queueId, eId, eType)
    .then((data) => dispatch({ type: t.LOAD_DATA, data }));

export const loadManagers = () => (dispatch) =>
  api.view.staff.user.tree().then((data) => dispatch({ type: t.LOAD_DATA, data }));

export const setFilter = (data) => (dispatch) => dispatch({ type: t.SET_FILTER, data });
export const setSelected = (data) => (dispatch) => dispatch({ type: t.SET_SELECTED, data });
export const reset = () => (dispatch) => dispatch({ type: t.RESET });
export const resetSearchText = () => ({ type: t.RESET_TEXT });
