import React from 'react';
import { connect } from 'react-redux';
import Modal from '@crm/components/dist/lego2/Modal';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import VTreeView from 'components/VTreeView';
import cx from 'classnames';
import filterTree from 'utils/filter-tree';
import Toolbar from 'components/Toolbar';
import css from './styles.scss';
import { mapState, mapDispatch } from './redux-map';
import Body from './Body';

export class SelectTreeDialog extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      item: null,
    };
  }

  componentDidMount() {
    if (this.props.initOnMount) {
      this.props.load();
    }
  }

  componentWillReceiveProps(newProps) {
    if (newProps.selectedItemId !== this.props.selectedItemId) {
      this.setState({
        currentSelect: undefined,
      });
    }
  }

  componentWillUnmount() {
    if (this.props.destroyOnUnmount) {
      this.props.destroy();
    }
  }

  onItemClick = (item) => {
    this.setState({
      item,
      currentSelect: item.id,
    });
  };

  onExit = () => {
    this.state.currentSelect = this.props.selectedItemId;
    if (this.props.onExit) {
      this.props.onExit();
    }
    if (this.props.onDialogRequestClose) {
      this.props.onDialogRequestClose(this.state.currentSelect);
    }
  };

  onOK = () => {
    const { ticketId } = this.props;
    const elId = this.state.currentSelect;
    const { callback } = this.props;
    if (callback) {
      callback(elId);
    }
    if (this.props.onOK) {
      this.props.onOK(this.state.item);
      return;
    }
    if (this.props.onItemClick) {
      this.props.onItemClick(elId);
    }
    if (this.props.onOKClick) {
      this.props.onOKClick(ticketId, elId);
    }
  };

  handleSubmit = (e) => {
    if (e.keyCode === 13 && this.state.currentSelect !== undefined) {
      this.onOK();
    }
  };

  render() {
    const { show, items, filter, onChangeFilterText, formHeader } = this.props;

    const headerClassName = cx(css.header, { [css.header_withMarginTop]: !formHeader });

    return (
      <Modal visible={Boolean(show)} onClose={this.onExit} size="fixHeight">
        <div tabIndex="-1" className={css.dialog} onKeyUp={this.handleSubmit}>
          <div className={headerClassName}>
            <h2 className="dialog__header">{formHeader}</h2>
            <Textinput value={filter} onChange={onChangeFilterText} autoFocus size="m" />
          </div>
          <Body>
            <VTreeView
              data={filterTree(items.items, filter)}
              onItemClick={this.onItemClick}
              selectedId={this.state.currentSelect}
              currentId={this.props.selectedItemId}
              isForceOpen={filter !== ''}
            />
          </Body>
          <div className={css.footer}>
            <Toolbar reverse>
              <Button
                size="m"
                view="action"
                disabled={
                  this.state.currentSelect == null ||
                  this.state.currentSelect === this.props.selectedItemId
                }
                onClick={this.onOK}
              >
                Сохранить
              </Button>
              <Button size="m" view="pseudo" onClick={this.onExit}>
                Отмена
              </Button>
            </Toolbar>
          </div>
        </div>
      </Modal>
    );
  }
}

export default connect(mapState, mapDispatch())(SelectTreeDialog);
