import * as t from './actionTypes';

let initState = {
    show : false,
    selected : null,
    selectedItemId : null,
    items : [],
    filter : '',
}

export default (state = initState, action) => {
    switch (action.type) {
        case t.TOGGLE:
            return { ...state, show: !state.show};
        case t.OPEN:
            return { ...state, show: true, callback: action.callback}
        case t.LOAD_DATA:
            return { ...state, items: action.data};
        case t.SET_FILTER:
            return { ...state, filter: action.data};
        case t.SET_SELECTED:
            return { ...state, selected: action.data, selectedItemId: action.data.id};
        case t.RESET:
            return initState;
        case t.RESET_TEXT:
            return { ...state, filter: ''};
        default:
            return state;
    };
}