import isUndefined from 'lodash/isUndefined';
import { NAME } from './constants';
import * as actions from './actions';

export const mapState = (state, props) => {
  const newProps = {
    ...state[NAME],
  };

  if (!isUndefined(props.show)) {
    newProps.show = props.show;
  }

  if (!isUndefined(props.selectedId)) {
    newProps.selectedItemId = props.selectedId;
  }

  return newProps;
};

export const mapDispatch = (loadAction = actions.loadData) => (dispatch, props) => ({
  toggle: () => {
    if (props.toggle) {
      props.toggle(false);
    } else {
      dispatch(actions.toggle());
    }
  },
  onChangeFilterText: (text) => dispatch(actions.setFilter(text)),
  onOK: (item = null) => {
    dispatch(actions.setSelected(item));
    dispatch(actions.resetSearchText());
    if (props.onChange) {
      props.onChange(item && item.id, item);
    }
    if (props.toggle) {
      props.toggle(false);
    } else {
      dispatch(actions.toggle());
    }
  },
  onExit: () => {
    if (props.toggle) {
      props.toggle(false);
    } else {
      dispatch(actions.toggle());
    }
    dispatch(actions.reset());
  },
  load: () => dispatch(loadAction(null, props.workplace, props.queueId, props.eId, props.eType)),
  destroy: () => {
    dispatch(actions.reset());
  },
});
