import { Environment } from './types';

export class Config {
  public static readonly startrekHosts = {
    [Environment.Test]: 'https://st.test.yandex-team.ru/',
    [Environment.Prod]: 'https://st.yandex-team.ru/',
    [Environment.External]: 'https://tracker.yandex.ru/',
  };

  public static readonly docviewerHosts = {
    [Environment.Test]: 'https://docviewer.tst.yandex-team.ru/',
    [Environment.Prod]: 'https://docviewer.yandex-team.ru/',
  };

  public readonly startrekHost: string;

  public readonly docviewerHost: string;

  public constructor(env: Environment) {
    this.startrekHost = Config.startrekHosts[env];
    this.docviewerHost = Config.docviewerHosts[env];
  }
}
