import { BackendError } from './BackendError';
import { BackendErrorCodeError } from './types';

export const isCsrfError = (error: BackendError) => {
  return (
    error.status === 403 &&
    (error.data.code === BackendErrorCodeError.CSRF ||
      error.data.code === BackendErrorCodeError.CSRFFrontendError)
  );
};
