import { logger } from 'services/Logger';
import { connectionChecker } from 'services/ConnectionChecker';
import { JqueryXMLHttpRequest, BackendErrorProps } from './types';
import { BackendError } from './BackendError';

export const processBackendError = (
  jqXHR: JqueryXMLHttpRequest,
  loggerPayload: BackendErrorProps['additional'] = {},
) => {
  const error = BackendError.createFromXhr(jqXHR, loggerPayload);
  if (!connectionChecker.isOnline() && error.status === 0) {
    error.isShowed = true;
  } else {
    logger.reportBackendError(error);
  }

  if (error.status === 401 && error.data.redirectTo) {
    window.location = error.data.redirectTo;
  }

  return error;
};
