import { apiCall, apiUploadFilesCall } from './common';

export default {
  file: {
    /**
     * @param args={objectName, objId, containerId, files[]}
     * @retunr {objId, containerId, files[]}
     * */
    add: (args) =>
      apiUploadFilesCall(`/actions/${args.objectName}/file/add`, {
        ...args,
        objectName: undefined,
      }),
    remove: (args) =>
      apiCall(
        `/actions/${args.objectName}/file/remove`,
        { ...args, objectName: undefined },
        'post',
      ),
    update: (args) =>
      apiCall(
        `/actions/${args.objectName}/file/updateLinks`,
        { ...args, objectName: undefined },
        'post',
      ),
  },
  support: {
    review: {
      item: {
        save: (args) => apiCall('/actions/support/review/item/save', args, 'post'),
        /**
         * @param {Object} args
         * @param {Number} args.reviewId
         *
         * @returns {Object} receive
         * @retrun {Boolean} receive.success
         * @retrun {Object} receive.item
         */
        addNew: (args) => apiCall('/actions/support/review/item/addNew', args, 'post'),
      },
    },
  },

  mail: {
    file: {
      updateLinks: (mailId, containerId, fileIdsToRemove = [], fileIdsToLink = []) =>
        apiCall(
          '/actions/mail/file/updateLinks',
          {
            mailId,
            containerId,
            fileIdsToRemove,
            fileIdsToLink,
          },
          'post',
          false,
        ),
    },
  },
};
