export default {
  actions: {},

  /**
   * @param type {String} - action type
   * @param func {function} - action function
   * */
  addListener(type, func) {
    if (typeof func === 'function') {
      this.actions[type] = func;
    }
  },

  removeListener(type) {
    delete this.actions[type];
  },

  dispatchActions(args) {
    if (Array.isArray(args.actions)) {
      args.actions.forEach((action) => {
        const listner = this.actions[action.type];
        if (listner) {
          listner(action.payload, window.reduxStore.dispatch);
        }
      });
    }
  },
};
