import { getHeaders } from './request';
import wid from './wid';

export const fetchWithSystemOptions = (input: RequestInfo, init?: RequestInit) => {
  const systemHeaders = getHeaders();
  const headers = init && init.headers ? { ...systemHeaders, ...init.headers } : systemHeaders;

  return fetch(wid(`${window.CRM_SPACE_API_HOST}${input}`), {
    ...init,
    headers,
  });
};
