// TODO: https://st.yandex-team.ru/CRM-10854 – remove dependency from notificationsUI
import { MessageLevel } from 'types/Message/MessageLevel';
import { push } from 'modules/notificationsUI/actions';

export default (e) => {
  const level = e.status === 202 ? MessageLevel.Warning : MessageLevel.Error;
  if (process.env.NODE_ENV !== 'test' && !e.isShowed) {
    window.reduxStore.dispatch(push({ text: e.message, level }));
  }

  e.isShowed = true;
  throw e;
};
