// TODO: https://st.yandex-team.ru/CRM-10854 – remove dependency from notificationsUI
import { MessageLevel } from 'types/Message/MessageLevel';
import { notificationPlay } from 'modules/notificationsUI/notificationPlay';
import { push } from 'modules/notificationsUI/actions';

export default (data) => {
  const backendMessages = data && data.messages;
  if (Array.isArray(backendMessages)) {
    backendMessages.forEach((msg) => {
      if (msg.sound) {
        notificationPlay.play();
      }

      window.reduxStore.dispatch(
        push({
          level: MessageLevel[msg.level],
          text: msg.text,
        }),
      );
    });
  }
};
