import { apiCall, apiCall3 } from './common';

export default {
  support: {
    review: {
      report: (args) => apiCall('/view/support/review/report', args),

      /**
       * @args {Object} : id - review id
       * */
      item: (args) => apiCall('/view/support/review/item', args),
    },

    category: {
      list: (id, workplace, queueId, eId, eType) => {
        if (workplace === 'request') {
          return apiCall('/view/support/category/list', {
            requestId: id,
            workplace,
            queueId,
            eId,
            eType,
          });
        }
        return apiCall('/view/support/category/list', {
          ticketId: id,
          workplace,
          queueId,
          eId,
          eType,
        });
      },
    },
  },

  staff: {
    user: {
      tree: () => apiCall('/view/staff/user/tree'),
    },
  },

  suggest: {
    email: (args) => apiCall3('/view/suggest/email', args),
    massmail: (args) => apiCall3('/view/suggest/email/managers', args),
  },
};
