import createGetStartrekLink from 'utils/createGetStartrekLink';
import { Config } from './Config';
import { Environment } from './types';

export { Environment };

export class App {
  private _config: Config;

  public getStartrekLink: (key: string) => string;

  public constructor(env: Environment = Environment.Test) {
    this.config = new Config(env);
  }

  public set config(config: Config) {
    this._config = config;
    this.getStartrekLink = createGetStartrekLink({
      external: Config.startrekHosts[Environment.External],
      local: this._config.startrekHost,
    });
  }

  public setEnv(env: Environment) {
    this.config = new Config(env);
  }
}

export default new App();
