import React, { useEffect } from 'react';
import RumProvider from 'services/Rum';
import { saveUserState } from './PersistState.utils';

export const PersistState: React.FC = () => {
  useEffect(() => {
    RumProvider.sendTimeMark('captureLocalStorageKeys', Date.now(), {
      keys: Object.keys(localStorage),
    });

    window.addEventListener('beforeunload', saveUserState);

    return () => {
      window.removeEventListener('beforeunload', saveUserState);
    };
  }, []);

  return null;
};
