/*
для перемещения писем в папки был использована библиотека https://github.com/react-dnd

Она блокирует все события dragNdrop кроме своих. Вот тред на эту проблему:
https://github.com/react-dnd/react-dnd-html5-backend/issues/7

На основание https://github.com/react-dnd/react-dnd-html5-backend/issues/7#issuecomment-262267786 сделал хак, который позволяет:
1) перемещать письма в папки
2) добавлять инлайны в письма
3) прикреплять файлы dragNdrop к письмам/комментариям/заметкам и т.д.
* */

import HTML5Backend from 'react-dnd-html5-backend';

export const REACT_DND_KEY = Symbol('REACT_DND_KEY');

const isReactDNDEvent = instance => {
  console.log(instance.monitor.getItemType());

  const item = instance.monitor.getItem() || {};

  return Object.prototype.hasOwnProperty.call(item, REACT_DND_KEY);
};

export default (...args) => {
  const instance = new HTML5Backend(...args);

  const listeners = ['handleTopDrop', 'handleTopDropCapture'];
  listeners.forEach(name => {
    const original = instance[name];
    instance[name] = (e, ...extraArgs) => {
      if (isReactDNDEvent(instance)) {
        original(e, ...extraArgs);
      }
    };
  });

  return instance;
};
