import React from 'react';
import { Route } from 'react-router-dom';
import { ErrorBoundaryModule } from 'components/ErrorBoundaryModule';
import { RouteWithErrorBoundaryProps } from './RouteWithErrorBoundary.types';
import { convertPathToKey } from './RouteWithErrorBoundary.utils';

export const RouteWithErrorBoundary: React.FC<RouteWithErrorBoundaryProps> = (props) => {
  return (
    <ErrorBoundaryModule key={convertPathToKey(props.path)}>
      <Route {...props} />
    </ErrorBoundaryModule>
  );
};
