import React, { Children } from 'react';
import PropTypes from 'prop-types';

class TabFocusHelper extends React.Component {
  static FOCUS_CLASS_NAME = 'utilityfocus';

  isTabNavigation = false;

  componentDidMount() {
    document.addEventListener('mousedown', this.handleDocumentMouseDown);
    document.addEventListener('keydown', this.handleDocumentKeyDown);
  }

  componentWillUnmount() {
    document.removeEventListener('mousedown', this.handleDocumentMouseDown);
    document.removeEventListener('keydown', this.handleDocumentKeyDown);
  }

  handleDocumentMouseDown = () => {
    if (this.isTabNavigation) {
      document.documentElement.classList.remove(TabFocusHelper.FOCUS_CLASS_NAME);
      this.isTabNavigation = false;
    }
  };

  handleDocumentKeyDown = e => {
    if (!this.isTabNavigation && e.key === 'Tab') {
      document.documentElement.classList.add(TabFocusHelper.FOCUS_CLASS_NAME);
      this.isTabNavigation = true;
    }
  };

  render() {
    return Children.only(this.props.children);
  }
}

TabFocusHelper.propTypes = {
  children: PropTypes.node,
};

TabFocusHelper.defaultProps = {
  children: undefined,
};

export default TabFocusHelper;
