import React from 'react';
import PropTypes from 'prop-types';
import ErrorPage from 'components/ErrorPage';

export default class Initial extends React.Component {
  static propTypes = {
    setRootInfo: PropTypes.func.isRequired,
    getOperatorStatus: PropTypes.func.isRequired,
    children: PropTypes.node,
    isError: PropTypes.bool,
    isLoad: PropTypes.bool,
  };

  static defaultProps = {
    children: undefined,
    isError: false,
    isLoad: false,
  };

  componentDidMount() {
    this.props.setRootInfo();
    this.props.getOperatorStatus();
  }

  render() {
    if (this.props.isError) {
      return <ErrorPage />;
    }

    if (this.props.isLoad) {
      return this.props.children;
    }

    return null;
  }
}
