import { createSlice } from '@reduxjs/toolkit';
import { panelUISlice } from 'modules/panel/redux/reducer';
import { resizeUISlice } from 'modules/resizable/redux/reducer';
import { NAME } from './constants';

export const initialState: { isInitialized: boolean; resize: object; panel: {} } = {
  isInitialized: false,
  resize: {},
  panel: {},
};

export const UISettingsSlice = createSlice({
  name: NAME,
  initialState,
  reducers: {
    initSettings: (state, { payload }) => {
      return {
        ...state,
        isInitialized: true,
        ...payload,
      };
    },

    ...resizeUISlice.caseReducers,
    ...panelUISlice.caseReducers,
  },
});

export default UISettingsSlice.reducer;
