import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import { actions as statusActions } from 'modules/userStatus';
import Initial from './Initial';
import * as actions from './actions';
import { getState } from './selectors';

const mapState = (state) => {
  const rootState = getState(state) || {};
  return {
    isLoad: rootState.isLoad,
    isError: rootState.isError,
  };
};

const mapDispatch = (dispatch) =>
  bindActionCreators(
    {
      ...actions,
      getOperatorStatus: statusActions.getStatus,
    },
    dispatch,
  );

export default connect(mapState, mapDispatch)(Initial);
