import Immutable from 'immutable';
import * as aTypes from './actionTypes';

export default (state = { info: { user: {} } }, action) => {
  switch (action.type) {
    case aTypes.INFO_REQUEST:
      return {
        ...state,
        isFetch: true,
      };
    case aTypes.INFO_RECEIVE:
      return {
        ...state,
        isFetch: false,
        isLoad: true,
        info: action.data,
      };
    case aTypes.INFO_FAIL:
      return {
        ...state,
        isFetch: false,
        isError: true,
      };
    case 'UPDATE_ROOT_INFO_IS_AUTOREPLY': {
      const newInfo = Immutable.fromJS(state.info).setIn(['isAutoreply'], action.status);
      return {
        ...state,
        info: newInfo.toJS(),
      };
    }
    case 'SET_FRONTEND_VERSION':
      return {
        ...state,
        frontendVersion: action.payload,
      };
    default:
      return state;
  }
};
