import { EnhancedStore, Reducer, ReducersMapObject } from '@reduxjs/toolkit';

export enum Environment {
  Prod = 1,
  Test,
  External,
}

export interface WithAsyncReducers {
  asyncReducers: ReducersMapObject;
  removeReducer(name: string): void;
  injectReducer: (
    this: EnhancedStore & WithAsyncReducers,
    name: string,
    reducer: Reducer,
    forceUpdate?: boolean,
  ) => void;
}

export interface WithLocalStorageReducers {
  localStorageReducers: ReducersMapObject;
  localStorageReducer: Reducer;
  injectReducerWithLocalStorage: (
    this: EnhancedStore & WithAsyncReducers & WithLocalStorageReducers,
    name: string,
    reducer: Reducer,
    forceUpdate?: boolean,
  ) => void;
}

export type AppStore = EnhancedStore & WithAsyncReducers & WithLocalStorageReducers;
