import { Reducer } from '@reduxjs/toolkit';
import combineReducers from 'utils/reducer/combineReducers';
import { WithLocalStorageReducers, WithAsyncReducers } from './types';

export const withLocalStorageReducer = <Store extends WithAsyncReducers>(reduxStore: Store) => {
  const store = Object.create(reduxStore) as Store & WithLocalStorageReducers;

  store.localStorageReducers = {};
  store.localStorageReducer = (state = {}) => state;

  store.injectReducerWithLocalStorage = function(name, reducer, forceUpdate): void {
    this.injectReducer(name, reducer, forceUpdate);
    if (!this.localStorageReducers[name]) {
      this.localStorageReducers[name] = reducer;
      this.localStorageReducer = combineReducers(this.localStorageReducers) as Reducer;
    }
  };

  return store;
};
