import { InitialLoadData } from 'types/Config';

let config: InitialLoadData | null | undefined = undefined;

export const getCrmConfig = (): InitialLoadData | null => {
  if (config !== undefined) {
    return config;
  }

  try {
    config = JSON.parse((document.getElementById('crm-config') as HTMLElement).textContent!);
  } catch (err) {
    config = null;
    console.warn("Couldn't read JSON data from crm-config", err);
  }

  return config as InitialLoadData;
};

export default getCrmConfig;
