import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import Toolbar from 'components/Toolbar';
import css from './styles.modules.scss';

const BaseFooter = (props) => {
  const {
    className,
    size,
    submitProps,
    cancelProps,
    submitText,
    cancelText,
    children,
    buttons,
  } = props;

  return (
    <div className={cx(css.root, className)}>
      {children}
      {buttons && (
        <Toolbar reverse>
          <Button size={size} view="action" type="submit" {...submitProps}>
            {submitText}
          </Button>
          <Button size={size} {...cancelProps}>
            {cancelText}
          </Button>
        </Toolbar>
      )}
    </div>
  );
};

BaseFooter.defaultProps = {
  size: 'm',
  submitText: 'Сохранить',
  cancelText: 'Отмена',
  submitProps: {},
  cancelProps: {},
  buttons: true,
};

export default BaseFooter;
