import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { Title } from '@crm/components/dist/Title';
import css from './styles.modules.scss';

const Form = ({ children, title, hint, className, theme, ...props }) => (
  <form className={cx(className, css.form, css[`form_theme_${theme}`])} {...props}>
    {title && <Title className={css.title}>{title}</Title>}
    {hint && (
      <div className={cx(css.hint, css.hint_marginBottom)}>
        Поля обозначенные <span className={css.requiredStar} /> – обязательные
      </div>
    )}
    {children}
  </form>
);

Form.propTypes = {
  className: PropTypes.string,
  theme: PropTypes.string,
  children: PropTypes.node,
  title: PropTypes.string,
  hint: PropTypes.bool,
};

Form.defaultProps = {
  className: undefined,
  theme: undefined,
  children: null,
  title: null,
  hint: true,
};

export default Form;
