import * as React from 'react';
import cx from 'classnames';
import css from './Message.scss';

interface Props {
  children: React.ReactNode;
  theme?: string;
}

const Message = (props: Props) => {
  const { children, theme } = props;

  return (
    <div className={cx(css.b, css[`b_theme_${theme}`])}>
      <i className="material-icons">warning</i>&nbsp;
      <span className={css.b__text}>{children}</span>
    </div>
  );
};

Message.defaultProps = {
  theme: 'warning',
};

export default Message;
