import React from 'react';
import PropTypes from 'prop-types';
import ModalField from 'requestForms/components/ModalField';
import TreeDialog from 'dialogs/TreeView/component';

const CategoryPreview = ({ fullPath }) => <span>{fullPath || '-'}</span>;

CategoryPreview.propTypes = {
  fullPath: PropTypes.string,
};

CategoryPreview.defaultProps = {
  fullPath: undefined,
};

const CategorySelect = ({ queueId, workplace, eId, eType, ...props }) => (
  <ModalField
    {...props}
    modal={TreeDialog}
    preview={CategoryPreview}
    modalProps={{ initOnMount: true, queueId, workplace, eId, eType }}
  />
);

CategorySelect.propTypes = {
  queueId: PropTypes.number,
};

CategorySelect.defaultProps = {
  queueId: undefined,
};

export default CategorySelect;
