import React from 'react';
import PropTypes from 'prop-types';
import { Field } from 'redux-form';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import legoReduxFormComponents from 'lego/redux-form';
import css from './styles.modules.scss';

const COMPONENTS = legoReduxFormComponents;

const getComponent = (component, isString) => {
  if (!isString) {
    return component;
  }

  return COMPONENTS[component] || COMPONENTS.input;
};

const ContactFieldArray = (props) => {
  const { fields, fieldsArray, label, withTags = false } = props;
  return (
    <div className={css.root}>
      {fields.map((item, index) => (
        <div key={`${item}_${index}`}>
          <div className={css.row}>
            {fieldsArray.map((field) => {
              const isString = typeof field.component === 'string' || !field.component;

              return (
                <Field
                  key={`${item}.${field.name}`}
                  className={cx(css.input, css[`input__${field.name}`])}
                  name={`${item}.${field.name}`}
                  component={getComponent(field.component, isString)} // extend later if needed
                  placeholder={field.label}
                  size="m"
                  tagsType={field.tagsType}
                >
                  {field.children}
                </Field>
              );
            })}
            {fields.length > 1 && (
              <Button
                view="clear"
                onClick={() => {
                  fields.remove(index);
                }}
                icon={(iconCls) => <Icon svg="cross" className={iconCls} />}
              />
            )}
          </div>
          {withTags && fieldsArray.some((field) => field.name === 'tags') && (
            <div>
              <Field name={`${item}.tags`} component={COMPONENTS.Tags} />
            </div>
          )}
        </div>
      ))}
      <Button
        className={css.add}
        view="pseudo"
        size="m"
        onClick={() => {
          fields.push({});
        }}
      >
        Добавить&nbsp;<span className={css.label}>{label}</span>
      </Button>
    </div>
  );
};

ContactFieldArray.propTypes = {
  fields: PropTypes.instanceOf(Object),
  fieldsArray: PropTypes.instanceOf(Object),
  label: PropTypes.instanceOf(Object),
};

ContactFieldArray.defaultProps = {
  fields: undefined,
  fieldsArray: undefined,
  label: undefined,
};

export default ContactFieldArray;
