import React from 'react';
import PropTypes from 'prop-types';
import Label from 'lego/components/Label';
import cx from 'classnames';
import css from './styles.modules.scss';

const FieldWrap = props => {
  const {
    className,
    view,
    name,
    label,
    hint,
    required,
    wrapProps,
    content,
    children,
    fieldWidth,
  } = props;

  return (
    <div className={cx(css[view], className, !label ? css.noLabel : null)} {...wrapProps}>
      {label && (
        <Label
          hasLine={false}
          className={css.row__label}
          required={required}
          htmlFor={name}
          size="m"
        >
          {label}
        </Label>
      )}
      <div className={cx(css.data, css[`data_fieldWidth_${fieldWidth}`])}>
        <div className={css.field}>
          {children}
          {hint && <div className={css.hint}>{hint}</div>}
        </div>
        {content && <div className={css.content}>{content}</div>}
      </div>
    </div>
  );
};

FieldWrap.propTypes = {
  className: PropTypes.string,
  fieldClassName: PropTypes.string,
  children: PropTypes.node,
  content: PropTypes.node,
  view: PropTypes.oneOf(['row']),
  name: PropTypes.string,
  component: PropTypes.oneOfType([PropTypes.string, PropTypes.func, PropTypes.element]),
  placeholder: PropTypes.string,
  label: PropTypes.string,
  hint: PropTypes.string,
  required: PropTypes.bool,
  wrapProps: PropTypes.instanceOf(Object),
  fieldWidth: PropTypes.string,
};

FieldWrap.defaultProps = {
  className: undefined,
  fieldClassName: undefined,
  children: undefined,
  content: undefined,
  view: 'row',
  name: undefined,
  component: 'input',
  placeholder: undefined,
  label: undefined,
  hint: undefined,
  required: false,
  wrapProps: {},
  fieldWidth: 'max',
};

export default FieldWrap;
