import React from 'react';
import SuggestWithTags from 'lego/redux-form/SuggestWithTags';

const subject = {
  map: {
    1: 'От Службы поддержки Яндекс.Маркета',
    2: 'Рекламная сеть Яндекса',
    3: 'ADFOX',
    4: 'От отдела клиентского сервиса',
    5: 'От отдела по работе с рекламными агентствами',
    6: 'ИНФО',
    7: 'От Службы поддержки Беру',
    8: 'Входящий звонок',
    9: 'Исходящий звонок',
    10: 'От отдела качества клиентского сервиса Яндекса',
  },
  list: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
};

const getSuggest = (text = '') => {
  if (typeof text === 'string' && text) {
    const lowerText = text.toLowerCase();
    const result = [];

    subject.list.forEach(index => {
      if (subject.map[index].toLowerCase().indexOf(lowerText) !== -1) {
        result.push({ name: subject.map[index], id: index });
      }
    });

    return result;
  }

  return subject.list.map(index => ({ name: subject.map[index], id: index }));
};

const Subject = props => (
  <SuggestWithTags
    {...props}
    provider={getSuggest}
    isCustomValue
    isSingleValue
    size="m"
    showOnFocus
  />
);

export default Subject;
